#ifndef __interrupts_h
#define __interrupts_h

// Note: As the interrupt system is currently setup, at the end
//       of each high-priority interrupt, the system will check to
//       see if the processor may be put to sleep.  This is done
//       with the call sleep_high_interrupt_if_okay() which is defined
//       in msg_queues.h -- init_queues() MUST be called prior to
//       enabling interrupts if sleep_high_interrupt_if_okay() is called!

// Initialize the interrupts
void interrupt_init(void);

// enable the interrupts (high and low priority)
void interrupt_enable(void);

// Are we calling from a high-priority interrupt?
int interrupt_in_high_interrupt_routine(void);

// Is a low-priority interrupt active?
int interrupt_low_int_active(void);

// Are we calling from a low-priority interrupt?
int interrupt_in_low_interrupt_routine(void);

// Are we calling this from the "main" routine (i.e., not an interrrupt handler?)
int interrupt_in_main_routine(void);

#endif
